#ifndef __CJPEGImage__
#define __CJPEGImage__

#include "CBaseImage.hpp"
using Exponent::GUI::Graphics::CBaseImage;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Graphics
		{
			/**
			 * @class CJPEGImage CJPEGImage.hpp
			 * @brief A jpeg image
			 *
			 * @date 03/02/2007
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CJPEGImage.hpp,v 1.2 2007/02/08 21:07:54 paul Exp $
			 */
			class CJPEGImage : public CBaseImage
			{
				/** @cond */
				EXPONENT_CLASS_DECLARATION;
				/** @endcond */

//	===========================================================================

			public:

//	===========================================================================
				
				/**
				 * Construction with a file name
				 * @param filename Name of the file to load
				 * @throws CException On load error
				 */
				CJPEGImage(const CSystemString &filename);

				/**
				 * Construction
				 */
				CJPEGImage();

				/**
				 * Destruction
				 */
				virtual ~CJPEGImage();

//	===========================================================================

				/**
				 * Get the format
				 * @retval EImageFormats The format of the image
				 */
				virtual EImageFormats getImageFormat() const { return e_jpeg; }

				/**
				 * Load from a file
				 * @param filename The name of the file
				 * @retval bool True if loaded the image properly, false on error
				 */
				virtual bool loadFromFile(const CSystemString &filename);

//	===========================================================================

				/**
				 * Get a new JPG image instance
				 * @param path The containing folder of the image
				 * @param filename the name of the file
				 * @retval CJPEGImage* The new instance or NULL on error
				 */
				static CJPEGImage *getNewInstance(const CSystemString &path, const CString &filename);
			};
		}
	}
}
#endif	// End of CJPEGImage.hpp